# Eine Einführung in R
#
# Vorab 
# 
# Eine "perfekte" oder auch nur verbindliche Einführung in 
# R existiert nicht, dies zeigt gerade die Vielfalt der 
# im Internet verfügbaren Skripte.

# Warum R ?
# kostenlos
# zahlreiche statistische Methoden, auch für Textanalyse
# Visualisierungen möglich
# in den Digital Humanities einer der Standards neben Python
# flexible Einsatzmöglichkeiten
# die statistische Auswertung von Texten hat eine lange Tradition
# in der Forensik: das Paket "stylo" mit seiner
# Funktion der "authorship attribution" war für die
# Ermittlung von Verfassern entwickelt worden


# Download R
# http://cran.r-project.org/
# Die aktuelle Version (Juni 2023) ist R 4.3.1.
# Wir werden mit dieser Version arbeiten. Im Zweifelsfall bitte
# auf diese Version upgraden!

# Erst nach der Installation von R:
# Download RStudio Desktop
# https://posit.co/downloads/
# Hier bitte die freie "RStudio Desktop" Version 
# herunterladen und installieren.  

############# Einführung: Erste Schritte ########################

# Was kann man mit R machen?
# Rechnen 
# auf Daten zugreifen
# "Data Wrangling", d.h. Rohdaten zur Auswertung aufbereiten
# Auswertungen
# Texte analysieren
# Daten und Auswertungen visualisieren

# R Befehle sind an die englische Sprache angelehnt
# Hilfetexte und Beispiele sind in Englisch verfasst.


# Alle folgenden Erläuterungen beziehen sich auf R und RStudio
# Code ausführen: In RStudio oder RGui haben Sie die Wahl zwischen drei
# Möglichkeiten: a) Irgendwo in die Codezeile klicken und Strg+Enter 
# ausführen; b) Mehrere markierte Zeilen ausführen (Strg+Enter ausführen)
# c) Das ganze Skript an die Konsole schicken: Irgendwo ins Editorfenster
# klicken und in RStudio entweder die Tastenkombination Strg+Shift+Enter 
# oder auf die Schaltfläche Source drücken

# Dezimalzeichen ist der Punkt "."

# Die Arbeitsumgebung

# Der Arbeitsbereich umfasst in R unter anderem alle Variablen und
# Funktionen (zusammengefasst unter dem Begriff Objekte), die Sie während
# Ihrer Sitzung erzeugt haben, sowie alle Pakete, die Sie geladen haben.

# Abfrage des Arbeitsverzeichnisses
getwd()

# Das Arbeitsverzeichnis selbst setzen
setwd()

# Wenn Sie mit Windows arbeiten, wird der Pfad mit Schrägstrichen (/)
# anstelle von umgekehrten Schrägstrichen (\) angezeigt. Das liegt daran,
# dass der Backslash in R eine besondere Bedeutung hat, wie in vielen
# anderen Programmiersprachen auch. Der Backslash leitet in R eine
# sogenannte Escape-Sequenz ein, das heißt, das folgende Zeichen wird nicht
# wörtlich übernommen. Beispielsweise bedeutet \t einen Tabulatorvorschub
# und nicht den Buchstaben t.

# was befindet sich in diesem Verzeichnis?
head(dir())

# Überblick über allgemeine Einstellungen in der aktuellen Sitzung
sessionInfo()

# Arbeitsbereich komplett bereinigen (Housekeeping)
rm(list= ls(all= TRUE))

# Hier schon mal vorweg: list= ein Objekt mit Elementen beliebigen Datentyps 

# Unterbrechen eines Befehls mit escape-Taste (während an der Konsole
# das Stop-Schild angezeigt wird) 


# Ihre Skriptdatei speichern Sie mithilfe der entsprechenden Anweisung 
# Ihres Editors (Diskettenzeichen). Im Menü File -> Save as ermöglicht es, 
# das Skript als R-Datei zu speichern (ist mit jedem simplen Editor
# editierbar)

# R ist kommandozeilenorientiert, Ausdrücke werden einfach eingegeben
1 + 2
2*2

# R Anweisungen können über mehrere Zeilen hinweg erfolgen.
# Solange die Anweisung nicht syntatktisch korrekt abgeschlossen wurde
# beginnt die Fortsetzungszeile mit einem automatisch eingesetzten "+".

# Mehrere Anweisungen werden mit ";" getrennt
# Anweisungsblöcke werden mit geschweiften Klammern
# zusammengefasst {...;...;...}

# Kommentare werden mit "#" eingeleitet
# Kommentare können direkt neben den Ausdruck geschrieben werden
2*2 # Nur zur Illustration der Kommentarfunktion

#################### Grundbegriffe #########################################
# Es gibt neben Vektoren und Listen noch eine Reihe weiterer Objekte in R.
# Namentlich 		Datenrahmen (data frames)
#               Matrizen (matrices),
#		          	Arrays und
#	          		Faktoren (factors)
#	

# Datenrahmen: Ein Datenrahmen kombiniert mehrere Vektoren, 
# um einen Datensatz zu erstellen. Sie können Vektoren nur dann 
# in einem Datenrahmen kombinieren, wenn sie die gleiche Länge haben. 
# Sie können jedoch verschiedenen Typs sein. 
# nrow() und ncol() zeigen die Anzahl der Zeilen (Beobachtungen) 
# und Variablen in einem Datenrahmen an.
# 
# Matrizen (Matrix): Ähnlich wie ein Datenrahmen enthält eine Matrix 
# mehrdimensionale Daten. Im Gegensatz zu einem Datenrahmen müssen 
# ihre Werte aber alle vom gleichen Typ sein.

mat <- matrix(c(1, 3, 6, 8, 3, 5, 2, 7), nrow = 2)
print(mat)

# Mit colnames() und rownames() kann man hier Namen vergeben:
colnames(mat) <- c("apple", "banana", "mandarin", "melon")
print(mat)

# 

# In R ist alles ein Objekt. Dies gilt für Daten wie für Funktionen.
# Intern wird jedes Objekt durch einen Vektor repräsentiert.
# 
# Den Objekten werden Werte z u g e w i e s e n 
#
# Z u w e i s u n g s o p e r a t o r ist die Zeichenfolge " <- "
# Von der (möglichen) Benutzung des Gleichheitszeichens "=" als 
# Zuweisungsoperator wird abgeraten (Verwechslungsgefahr).  
# Der Zuweisungsoperator erzeugt Objekte, um Inhalte oder Zwischenergebnisse 
# zu speichern.
# Die Namen für die Objekte sollten aussagekräftig sein und 
# sollten von Dritten nachvollzogen werden können.
# Es gibt Konventionen bei der Namensgebung: 
# camelCase-Notation ("Binnenversalien"): EinLangerVektorName und 
# dottet style: ein.langer.vektor.name
# oder die Verbindung mit einem Unterstrich: ein_langer_Vektor_Name
# Wenn Sie im Code irgendwo einen Punkt sehen: Keine Angst, der tut nichts.
# Er ist nur Teil des Namens.

# Vektoren
# Ein Vektor ist eine eindimensionale Menge von Elementen gleichen
# Typs. Ein Vektor ist die einfachste Datenstruktur in R, gleichzeitig
# stellt er das kleinste Element dar, mit dem R arbeitet (eindimensional!).
# Selbst ein einzelner Wert ist ein Vektor - mit einem Element.
# Eine Ansammlung von Zahlen ist ein numerischer Vektor. Vektoren können
# in R auch andere Objekttypen enthalten, zum Beispiel Zeichenketten.
# Das nennt man dann Zeichenvektor.

################## Erzeugung von Vektoren ###############################

# Zeichen oder Zeichenketten (Text)
# Texte müssen in R immer in Anführungszeichen gesetzt werden. Dabei ist
# es egal, ob einfache oder doppelte Anführungszeichen verwendet werden.
h <- "Hallo"
h
hw <- c("Hallo", "Welt!")
hw

# Um mehrere Textelemente zu einem einzigen zu verbinden, können Sie die 
# Funktion paste() verwenden. Standardmäßig trennt diese Funktion die 
# Elemente mit einem Leerzeichen, etwa so
paste("Hallo", "Welt!")
#
# Mit der Funktion paste können Elemente auch miteinander kombiniert werden
b <- paste("Komponente", c(1:6))
# Im Zeichenvektor b sind jetzt alle Kombinationen aus "Komponente" und den
# Zahlen 1 bis 6 enthalten. Wir schauen uns die ersten drei Kombinationen an:
b[1:3]

# Eine vektorwertige Funktion manipuliert nicht nur eine einzige 
# Eingangsgröße, sondern gleich einen ganzen Vektor. Um vektorwertige
# Funktionen verwenden zu können, benötigen Sie zunächst einmal einen
# Vektor. Dazu verwenden sie die Funktion c() (von englisch concatenate
# = verketten). Die einzelnen Elemente trennen Sie durch Kommata
vornamen <- c("Inga", "Linda", "Franz", "Tim")
nachnamen <- "Fox"
# Nun bietet ihnen die Funktion paste() die Möglichkeit an, die beiden
# Vektoren miteinander zu kombinieren
paste(vornamen, nachnamen)
# Wie Sie sehen, nimmt R den Vektor vornamen und klebt den Inhalt der
# Variablen nachname an jedes Element von vornamen dran.
# Hinter den Kulissen kombiniert R zwei Vektoren. In unserem Beispiel
# hat der zweite Vektor nur ein Element. Damit R die beiden Vektoren
# elementweise zusammenfügen kann, wird von paste() der zweite Vektor
# einfach so lange wiederholt, bis beide die gleiche Zahl an Elementen
# haben. Passenderweise nennt man das Recycling (und das öffnet die Tür
# für kombinatorische Poesie). Das geht auch mit längeren Vektoren:
vornamen <- c("Inga", "Linda", "Franz", "Tim")
nachnamen <- c("Lehmann", "Schneider")
paste(vornamen, nachnamen)

vornamen <- c("Inga", "Linda", "Franz", "Tim")
nachnamen <- c("Lehmann", "Schneider", "Woitkowitz")
paste(vornamen, nachnamen)

# Es gibt verschiedene Typen von Vektoren
# a) numerische Vektoren (numeric), die alle Arten von Zahlen enthalten
Zahlen <- seq(1,10,0.5)
# b) Ganzzahlvektoren (integer), die ganze Zahlen enthalten. Ein
auchZahlen <- 1:10
# ganzzahliger Vektor ist eine spezielle Spielart von numerischen Vektoren.
# c) logische Vektoren (logic), die logische Werte (TRUE und/oder FALSE)
# enthalten
# d) Zeichenvektoren (character), die Text enthalten
Buchstaben <- letters
Kontinente <- names(islands) 
# letters und islands sind Datensätze, die in den Basispaketen enthalten sind
# e) Datum-/Uhrzeitvektoren (datetime), die Datumsangaben und Uhrzeiten
# in unterschiedlichsten Formaten enthalten
# f) Faktoren (factor), Spezialvektoren für die Arbeit mit Kategorien
x <- c(1:3)
# Um zu erfahren, ob x ein numerischer Vektor ist, verwenden Sie
is.numeric(x)
# Jetzt könnten Sie denken, dass x ein Ganzzahlvektor ist. 
# Das testet man so:
is.integer(x)

# Auskunft über Vektoren: Die Funktion str() liefert Ihnen Informationen
# über Typ und Struktur eines Objekts im Argument
str(x) 

# Länge eines Vektors, d.h. Anzahl der Elemente length()
length(x)

# Sortieren
y <- c(8, 3, 5, 7, 6, 6, 8, 9, 2, 3, 9, 4, 10, 4, 11)
sort(y)

rev(sort(y)) # absteigende Reihenfolge
sort(y, dec= T) # alternative Formulierung: dec = decreasing


########## Objekte, Datentypen und Datenstrukturen in R #####################
# Objekte bestehen letztlich aus Basisdatentypen.
# Die Basisdatentypen lassen sich in verschiedenen Kategorien zusammenfassen.
# Bei diesen Kategorien handelt es sich um:
#   Vektoren, 
#	  zusammengesetzte Datentypen, 
#	  spezielle Objekte, 
#	  Sprachobjekte,
# 	Funktionen und 
#	  interne Datentypen.
#
#	  einige Datentypen
#	  Datentyp      Beschreibung
#	  NULL          leere Menge
#	  logical		    logische Werte, TRUE, FALSE
#	  numeric		    ganze und reelle Zahlen (integer, double) 
#	                Beispiele:    12 8.8	 
#   complex		    komplexe Zahlen
#   character   	Buchstaben und Zeichenfolgen (in "")
#
#   Abfrage des Datentyps
#	  is.numeric(), is.integer(), is.double(), is.complex(), 
#	  is.logical(), is.character(),
#   is.na()
#
#	  Umwandlung des Datentyps
#	  as.numeric(), as.integer(), as.double(), as.complex(), 
#	  as.logical(), as.character(),
#   as.factor()
as.character(12)
as.numeric("12")

# R beachtet Groß- und Kleinschreibung. Für R sind also nachname und
# Nachname unterschiedliche Objekte. Es kann vorkommen, dass R ein Objekt
# nicht wiederfindet, obwohl Sie Stein und Bein schwören, es erzeugt zu
# haben. In so einem Fall ist die Erinnerung an Groß-/Kleinschreibung
# Gold wert.

# class() definiert den abstrakten Typ eines Objekts.
# Eine Zahl kann verschiedene Dinge repräsentieren: Eine PS-Angabe,
# oder einen Zeitpunkt (berechnet in Sekunden seit dem 01. Januar 
# 1970).
# In beiden Fällen sind die Angaben vom Typ numeric, aber das Datum
# besitzt die Klasse "Date".

Datum <- as.Date("2014-04-01")
mode(Datum)
class(Datum) 

# class() teilt R mit, wie ein Objekt zu interpretieren und zu
# verarbeiten ist.
class(x)
class(Zahlen)
class(Buchstaben)
class(Kontinente)


############# Daten in R einlesen und schreiben #########################
# R kann Daten aus einer Vielzahl von Quellen 
# wie etwa 	CSV, 
#		        Excel, 
# 		      Internet, 
# 		      Statistikpakete (SAS, SPSS, ...) und
# 		      Datenbanken
# importieren.
# Einen guten Überblick bieten:
# http://www.statmethods.net/input/importingdata.html
# und
# http://www.r-bloggers.com/importing-data-into-r-from-different-sources/

# In R wird die Funktion read.csv() für den Import von CSV-Dateien 
# verwendet (CSV = comma separated values). Beispiel:
daten <- read.csv(file = "IndexInd_Anteile_PLR_MSS2015.csv", header= T, sep= ",", dec= ",", encoding = "UTF-8") # Beispieldatensatz: 2.1.IndexInd_Anteile_PLR_MSS2015.csv
# Argumente: file = verweist auf eine Datei, 
# header = TRUE heißt, dass es eine Kopfzeile 
# mit Variablenbeschreibungen gibt, 
# sep bezeichnet das Trennzeichen (Komma ist voreingestellt)
# dec heißt, dass es Dezimalzeichen mit Komma abgetrennt geben kann
# encoding = "UTF-8" bezeichnet die Kodierung für den Unicode-Zeichensatz

# Datensätze können mit folgenden Befehlen untersucht werden:
names(daten) # Beschreibung der Kopfzeilen werden abgerufen
dim(daten) # Dimensionen des Datensatzes
str(daten) # Struktur des Datensatzes
head(daten) # Beginn des Datensatzes
tail(daten) # Ende des Datensatzes
head(daten$Name) # Beginn des Datensatzes, Spalte "Name"

# Beachten Sie, dass standardmäßig Text in sog. Faktoren umgewandelt wird, 
# d.h. in kategoriale Daten. Damit die Umwandlung in Faktoren
# für Text unterbleibt, setzen Sie in den Funktionen read.csv() 
# und read.table() das Argument stringsAsFactors = FALSE ein.
# Beachten Sie auch, dass Leerzeichen in Spaltennamen in Punkte
# umgewandelt werden. 

# Kopieren und Einfügen über die Zwischenablage
# Ein weiterer Weg, Daten interaktiv einzulesen, besteht in der Verwendung
# von copy + paste über die Zwischenablage (clipboard)
# Um Daten aus der Zwischenablage zu importieren, verwenden Sie die 
# Funktion readLines("clipboard"). 
# Einlesen von Text
x <- readLines("clipboard")
x

# Einlesen einer Excel-Tabelle
data_excel <- read.delim("clipboard", sep = "\t") # Trennzeichen ist Tabulator
data_excel

##################### Hilfe in R ####################################
# Lokale Hilfe
# Aufruf der Hilfe zu einer Funktion mit bekanntem Namen: Geben Sie
# ein Fragezeichen gefolgt von einem Funktionsnamen ein
?paste 
?write.csv2
# Sie können auch help gefolgt von der gesuchten Funktion in Klammern
# eingeben, etwa so
help(paste)

# RSiteSearch durchsucht das Internet nach Stichwörtern
# RSiteSearch("Boxplot")
# alternative WebSite zur Suche http://rseek.org/

# Struktur der Hilfeseite, z.B. ?mean
# 	Beschreibung
#	  Gebrauch
# 	Argumente
#   Werte
#	  Referenz
#	  weiterführende Hinweise
#	  Beispiel

# Alternativ
help(mean)
help(write.csv2)

# Hilfetexte richtig interpretieren
# Unter "Usage" findet sich im Hilfetext die Darstellung des korrekten 
# Gebrauchs einer Funktion. Es gelten folgende Konventionen:
# Die Klammern enthalten die Argumente der Funktion
# Argumente mit einem Gleichheitszeichen sind nicht zwingend erforderlich.
# Argumente ohne Gleichheitszeichen müssen angegeben werden.
# Bei frei wählbaren Argumenten werden die Default Werte angezeigt.
write.table(x, file = "", append = FALSE, quote = TRUE, sep = " ",
            eol = "\n", na = "NA", dec = ".", row.names = TRUE,
            col.names = TRUE, qmethod = c("escape", "double"),
            fileEncoding = "")
			
# Erläuterungen zu den Argumenten finden sich im Hilfetext unter "Arguments"
args() # Argumente und voreingestellte Werte (Defaults) einer Funktion 

# Beispiel für die korrekte Verwendung einer Funktion
example(median)
example(read.csv2) 

# Schließlich: Wenn etwas nicht funktioniert, 
# den Fehlercode googeln: r + "ErrorCode"
# Eine sehr hilfreiche Seite ist Stackoverflow:
# https://stackoverflow.com/questions/tagged/r
# 90% allen codens in R und Python basieren auf dieser Seite...

# Für einige Funktionalitäten existieren Demos.
# demo() gibt einen Überblick über die verfügbaren Demos
demo()

# Zahlreiche Funktionen werden in Paketen (Packages) bereitgestellt

# Überblick über installierte Pakete:
installed.packages()

# Installieren und nutzen von Paketen
install.packages("tm")

# Bereitstellung eines Pakets
library(dplyr)

# Die in einem Paket enthaltenen Funktionen
lsf.str("package:dplyr", all = TRUE)

# Programmbeschreibungen zu den Packages können im Internet mit 
# Vignette "Paketname" abgerufen werden ("begleitende PDF")
vignette("tm")

############### Literatur zum Arbeiten mit R ##############################
# Roger Peng, R Programming for Data Science
# https://bookdown.org/rdpeng/rprogdatascience/

# Zwei Blogs für die Textanalyse mit R:
# https://juliasilge.com/ und https://www.kaylinpavlik.com/ 
# Ausführliche Literaturliste mit Einführungstexten in analytisches Koding:
# https://docs.google.com/spreadsheets/d/1lnmu7ET-HD-kPsbgtWVzf4PlhWx3W6LpKhqup3DWzG0/edit#gid=0 
# Dazu die Annotationen von Scott B. Weingart unter
# http://scottbot.net/teaching-yourself-to-code-in-dh/


# Wichtigste Literatur für die Textanalyse in R: 
# Matthew Jockers, Text Analysis with R for Students of Literature (2021)
# Step-by-step introduction to learning R, specifically focused on 
# literary text analysis, both for close and distant reading, 
# with primers on the statistical approaches being used. 
# Includes approaches to, e.g., word frequency distribution, lexical variety, 
# classification, and topic modeling.

# Lincoln A. Mullen, Computational Historical Thinking. With Applications in R
# http://dh-r.lincolnmullen.com/
# A series of lessons in in R, still under development with quite a few chapters 
# missing. Probably the only programming book aimed at 
# historians that actually focuses on historical questions and approaches.

# Brandon Walsh & Sarah Horowitz, Introduction to Text Analysis. A Coursebook
# http://walshbr.com/textanalysiscoursebook/
# A brief textbook with exercises and explanatory notes specific to 
# text analysis for the study of literature and history. 
# Not an introduction to programming, but covers some of the mathematical and methodological concepts used in these sorts of studies.

# Julia Silge and David Robinson, Text Mining with R. A tidy approach (2017).
# https://www.tidytextmining.com/
# Introduction to text mining aimed at data scientists 
# in the statistical programming language R. Some knowledge of R is expected; 
# the authors suggest using R for Data Science (2016) by Grolemund & Wickham 
# to get up to speed. This is for those interested in current data science 
# coding best-practices, though it does not get as in-depth as some other texts 
# focused on literary text analysis. Good as a solid base to learn from.

# RPubs: Basic Text Mining in R 
# https://rpubs.com/pjmurphy/265713 
